/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.action.protocol.ProtocolGoToPage;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.JsonCondition;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.data.content.ContentBlockInteraction;
import slimeknights.mantle.client.book.data.content.ContentCrafting;
import slimeknights.mantle.client.book.data.content.ContentImage;
import slimeknights.mantle.client.book.data.content.ContentImageText;
import slimeknights.mantle.client.book.data.content.ContentIndex;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.data.content.ContentShowcase;
import slimeknights.mantle.client.book.data.content.ContentSmelting;
import slimeknights.mantle.client.book.data.content.ContentSmithing;
import slimeknights.mantle.client.book.data.content.ContentStructure;
import slimeknights.mantle.client.book.data.content.ContentText;
import slimeknights.mantle.client.book.data.content.ContentTextImage;
import slimeknights.mantle.client.book.data.content.ContentTextLeftImage;
import slimeknights.mantle.client.book.data.content.ContentTextRightImage;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.deserializer.ConditionDeserializer;
import slimeknights.mantle.client.book.data.deserializer.HexStringDeserializer;
import slimeknights.mantle.client.book.data.element.IngredientData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.client.book.transformer.IndexTransformer;
import slimeknights.mantle.data.ResourceLocationSerializer;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.network.packet.UpdateHeldPagePacket;
import slimeknights.mantle.network.packet.UpdateLecternPagePacket;

public class BookLoader
implements SimpleSynchronousResourceReloadListener {
    private static Gson gson;
    private static boolean gsonDirty;
    private static final HashMap<Type, Object> gsonTypeAdapters;
    private static final HashMap<class_2960, Class<? extends PageContent>> typeToContentMap;
    private static final HashMap<class_2960, BookData> books;

    public BookLoader() {
        BookLoader.registerPageType(ContentBlank.ID, ContentBlank.class);
        BookLoader.registerPageType(ContentText.ID, ContentText.class);
        BookLoader.registerPageType(ContentPadding.LEFT_ID, ContentPadding.ContentLeftPadding.class);
        BookLoader.registerPageType(ContentPadding.RIGHT_ID, ContentPadding.ContentRightPadding.class);
        BookLoader.registerPageType(ContentImage.ID, ContentImage.class);
        BookLoader.registerPageType(ContentImageText.ID, ContentImageText.class);
        BookLoader.registerPageType(ContentTextImage.ID, ContentTextImage.class);
        BookLoader.registerPageType(ContentTextLeftImage.ID, ContentTextLeftImage.class);
        BookLoader.registerPageType(ContentTextRightImage.ID, ContentTextRightImage.class);
        BookLoader.registerPageType(ContentCrafting.ID, ContentCrafting.class);
        BookLoader.registerPageType(ContentSmelting.ID, ContentSmelting.class);
        BookLoader.registerPageType(ContentSmithing.ID, ContentSmithing.class);
        BookLoader.registerPageType(ContentBlockInteraction.ID, ContentBlockInteraction.class);
        BookLoader.registerPageType(ContentStructure.ID, ContentStructure.class);
        BookLoader.registerPageType(ContentIndex.ID, ContentIndex.class);
        BookLoader.registerPageType(ContentShowcase.ID, ContentShowcase.class);
        StringActionProcessor.registerProtocol(Mantle.getResource("go-to-page"), new ProtocolGoToPage(false));
        StringActionProcessor.registerProtocol(Mantle.getResource("go-to-page-rtn"), new ProtocolGoToPage(true));
        BookLoader.registerGsonTypeAdapter(class_2960.class, ResourceLocationSerializer.resourceLocation("mantle"));
        BookLoader.registerGsonTypeAdapter(Integer.TYPE, new HexStringDeserializer());
        BookLoader.registerGsonTypeAdapter(JsonCondition.class, ConditionDeserializer.DESERIALIZER);
        BookLoader.registerGsonTypeAdapter(IngredientData.class, new IngredientData.Deserializer());
        IndexTransformer.addHiddenPageType(ContentBlank.ID);
        IndexTransformer.addHiddenPageType(ContentPadding.LEFT_ID);
        IndexTransformer.addHiddenPageType(ContentPadding.RIGHT_ID);
        IndexTransformer.addHiddenPageType(ContentIndex.ID);
    }

    public static void registerPageType(class_2960 id, Class<? extends PageContent> clazz) {
        if (typeToContentMap.containsKey(id)) {
            throw new IllegalArgumentException("Page type " + String.valueOf(id) + " already in use.");
        }
        typeToContentMap.put(id, clazz);
    }

    @Nullable
    public static Class<? extends PageContent> getPageType(class_2960 name) {
        return typeToContentMap.get(name);
    }

    public static BookData registerBook(class_2960 id, BookRepository ... repositories) {
        return BookLoader.registerBook(id, true, true, repositories);
    }

    public static BookData registerBook(class_2960 id, boolean appendIndex, boolean appendContentTable, BookRepository ... repositories) {
        BookData info = new BookData(repositories);
        if (appendIndex) {
            info.addTransformer(BookTransformer.indexTranformer());
        }
        if (appendContentTable) {
            info.addTransformer(BookTransformer.contentTableTransformer());
        }
        books.put(id, info);
        return info;
    }

    @Nullable
    public static BookData getBook(class_2960 id) {
        return books.getOrDefault(id, null);
    }

    public static void updateSavedPage(@Nullable class_1657 player, class_1268 hand, String page) {
        class_1799 item;
        if (player != null && !(item = player.method_5998(hand)).method_7960()) {
            BookHelper.writeSavedPageToBook(item, page);
            MantleNetwork.INSTANCE.network.sendToServer((C2SPacket)new UpdateHeldPagePacket(hand, page));
        }
    }

    public static void updateSavedPage(class_2338 pos, String page) {
        MantleNetwork.INSTANCE.network.sendToServer((C2SPacket)new UpdateLecternPagePacket(pos, page));
    }

    public static Gson getGson() {
        if (gson == null || gsonDirty) {
            GsonBuilder builder = new GsonBuilder();
            for (Type type : gsonTypeAdapters.keySet()) {
                builder.registerTypeAdapter(type, gsonTypeAdapters.get(type));
            }
            gson = builder.create();
            gsonDirty = false;
        }
        return gson;
    }

    public static void registerGsonTypeAdapter(Type type, Object adapter) {
        gsonTypeAdapters.put(type, adapter);
        gsonDirty = true;
    }

    public static void resetAllBooks() {
        books.forEach((s, bookData) -> bookData.reset());
    }

    public void method_14491(class_3300 resourceManager) {
        BookLoader.resetAllBooks();
    }

    public class_2960 getFabricId() {
        return Mantle.getResource("book_loader");
    }

    static {
        gsonDirty = true;
        gsonTypeAdapters = new HashMap();
        typeToContentMap = new HashMap();
        books = new HashMap();
    }
}

